/*
 * File: WriteFile.java
 * ===============================================================
 * A program that writes text into a file.
 */

import acm.program.*;
import java.io.*;

public class WriteFile extends ConsoleProgram {
	/* THe name of the file to write to. */
	private static final String FILE_NAME = "test.txt";
	
	public void run() {
		try {
			/* Open the file for writing. */
			PrintWriter writer = new PrintWriter(new FileWriter(FILE_NAME));
			
			/* Output a message. */
			writer.println("This file was created by our program!");
			
			/* Close the file. */
			writer.close();
		} catch (IOException e) {
			println("An error occurred opening the file.");
		}
	}
}
